clear all
set more off
set maxvar 20000
set matsize 11000

/* load unified LP analysis program and mi program into memory */
do "..\unified LP programs\lp_drinking_unified_prog.do"
do "..\unified LP programs\mi_lp_drinking_unified_prog.do"

/* parameters to set */
local agg_type = "agg_agg" /* set the estimation approach to use */
*local agg_type = "agg_disagg" /* set the estimation approach to use */

/*
/* Data for Table 1: Outline of LP Replication Exercise  (can ignore the estimation section, since Table 1 reports summary statistics) */
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 1 .13 0 0

/* Data for bottom of Table 1: Outline of LP Replication Exercise  (definition has changed to definition 5, which runs the supplemental analysis, so need only look at the section "FOR BOTTOM HALF OF TABLE 1" ) */
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 5 0.13 0 0

/* Data for Table 2: Distribution of police officer judgement of alcohol involvement and BAC test results (see section "Cross-tab for Table 2")  */
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 2 .13 0 0

/* Data for Table 3: Potential definitions  of drinking driver (see the section "For Table 3"). */
/* Data for Table 5, columns 1-4 */
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 1 1 0 0
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 2 1 0 0
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 3 1 0 0
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 4 1 0 0

/* Data for Table 5, top part of columns for 20% and 13% dropping thresholds */
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 2 .13 0 0 /* including 13% to most closely match LP's unrestricted sample size */

/* Data for Table 5, bottom (restricted, dropping between 0 BAC and 10% BAC) part of columns for 20% and 13% dropping thresholds */
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 5 1 10 0
lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.weekend 5 .13 10 0 /* including 13% to most closely match LP's unrestricted sample size */
*/

/* Results for Table 6 and Appendix Table 1: Relative likelihood of causing a fatal crash under different levels of equal mixing and alcohol involvement definitions */
foreach def in 1 2 3 4{ /* 4 definitions */
	local table_text_theta = "Def. `def' theta"
	local table_text_theta_se = "Def. `def' theta_se"
	local table_text_lambda = "Def. `def' lambda"
	local table_text_lambda_se = "Def. `def' lambda_se"
	local table_text_df = "Def. `def' df"
	*foreach mx in "cons_one" "i.hour" "i.hour#i.year" "i.hour#i.year#i.weekend" "i.hour#i.state#i.year" "i.hour#i.state#i.year#i.weekend" {
	foreach mx in "i.hour#i.state#i.year#i.weekend" {
		lp_drinking_unified_prog `agg_type' 1983 1993 24 0 `mx' `def' .13 0 0
		local table_text_theta = "`table_text_theta'" + "," + strofreal(`r(theta)',"%9.2f")
		local table_text_theta_se = "`table_text_theta_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + ")"
		local table_text_lambda = "`table_text_lambda'" + "," + strofreal(`r(lambda)',"%9.2f")
		local table_text_lambda_se = "`table_text_lambda_se'" + ",'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
		local table_text_df = "`table_text_df'" + "," + strofreal(`r(df)',"%9.2f")
	}
	local table_text_`def' = "`table_text_theta'" + char(10) + "`table_text_theta_se'" + char(10) + "`table_text_lambda'" + char(10) + "`table_text_lambda_se'" + char(10) + "`table_text_df'" + char(10)
}

local table_text_theta = "Def. 5 theta"
local table_text_theta_se = "Def. 5 theta_se"
local table_text_lambda = "Def. 5 lambda"
local table_text_lambda_se = "Def. 5 lambda_se"
local table_text_df = "Def. 5 df"
foreach mx in "i.hour#i.state#i.year#i.weekend" {
	lp_drinking_unified_prog `agg_type' 1983 1993 24 0 `mx' 5 .13 10 0
	local table_text_theta = "`table_text_theta'" + "," + strofreal(`r(theta)',"%9.2f")
	local table_text_theta_se = "`table_text_theta_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + ")"
	local table_text_lambda = "`table_text_lambda'" + "," + strofreal(`r(lambda)',"%9.2f")
	local table_text_lambda_se = "`table_text_lambda_se'" + ",'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
	local table_text_df = "`table_text_df'" + "," + strofreal(`r(df)',"%9.2f")
}
local table_text_5 = "`table_text_theta'" + char(10) + "`table_text_theta_se'" + char(10) + "`table_text_lambda'" + char(10) + "`table_text_lambda_se'" + char(10) + "`table_text_df'" + char(10)
disp "`table_text_5'"

foreach dt in 0 10 {
    local table_text_theta = "MI theta"
	local table_text_theta_se = "MI theta_se"
	local table_text_lambda = "MI lambda"
	local table_text_lambda_se = "MI lambda_se"
	local table_text_df = "MI df"
	mi_lp_drinking_unified_prog `agg_type' 1983 1993 24 0 i.hour#i.state#i.year#i.weekend 6 .13 `dt'
	local table_text_theta = "`table_text_theta'" + "," + strofreal(`r(theta)',"%9.2f")
	local table_text_theta_se = "`table_text_theta_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + ")"
	local table_text_lambda = "`table_text_lambda'" + "," + strofreal(`r(lambda)',"%9.2f")
	local table_text_lambda_se = "`table_text_lambda_se'" + ",'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
	local table_text_df = "`table_text_df'" + "," + strofreal(`r(df)',"%9.2f")
	local table_text_mi_`dt' = "`table_text_theta'" + char(10) + "`table_text_theta_se'" + char(10) + "`table_text_lambda'" + char(10) + "`table_text_lambda_se'" + char(10) + "`table_text_df'" + char(10)
}
disp "`table_text_mi_10'"
log using table_6_text, replace
disp "****Copy and pasteable (into Google sheets) estimates for Table 6: "
foreach def in 1 2 3 4 "mi_0" 5 "mi_10" { /* 5 definitions plus MI*/
	disp "`table_text_`def''"
}
log close

/*
/* Results for Appendix Figures 1 and 3: Year-specific estimates, by drinking definition, and by exclusion percent */
foreach def in 1 2 3 4 { /* 4 definitions */
	local table_text_`def' = ""
	forvalues yr = 1983(1)1993 {
		local table_text_pt = "`yr'"
		local table_text_se = "`yr'"
		*foreach dt in .13 1 { /* 13% and no dropping thresholds */
		foreach dt in .13 { /* 13% and no dropping thresholds */
			lp_drinking_unified_prog `agg_type' `yr' `yr' 24 0 i.hour#i.weekend#i.state `def' `dt' 0
			local table_text_pt = "`table_text_pt'" + "," + strofreal(`r(theta)',"%9.2f") + "," + strofreal(`r(lambda)',"%9.2f")
			local table_text_se = "`table_text_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + "),'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
		}
		local table_text_`def' = "`table_text_`def''" + "`table_text_pt'" + char(10)
		local table_text_`def' = "`table_text_`def''" + "`table_text_se'" + char(10)
	}
}
/* then for multiple imputation */
local table_text_mi = ""
forvalues yr = 1983(1)1993 {
	local table_text_pt = "`yr'"
	local table_text_se = "`yr'"
	*foreach dt in .13 1 { /* 13%, and no dropping thresholds */
	foreach dt in .13 { /* 13%, and no dropping thresholds */
		mi_lp_drinking_unified_prog `agg_type' `yr' `yr' 24 0 i.hour#i.weekend#i.state 4 `dt' 0 0
		local table_text_pt = "`table_text_pt'" + "," + strofreal(`r(theta)',"%9.2f") + "," + strofreal(`r(lambda)',"%9.2f")
		local table_text_se = "`table_text_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + "),'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
	}
	local table_text_mi = "`table_text_mi'" + "`table_text_pt'" + char(10)
	local table_text_mi = "`table_text_mi'" + "`table_text_se'" + char(10)
}

log using figure_1_3_table_text, replace
foreach def in 1 2 3 4 "mi" { /* 4 definitions and multiple imputation */
	disp "****Copy and pasteable (into Google sheets) estimates for Figures 1 and 3, drinking definition `def': "
	disp "`table_text_`def''"
}
log close

/* Results for Appendix Figures 2 and 4: Hour-specific estimates, by drinking definition, and by exclusion percent */
foreach def in 1 2 3 4 { /* 4 definitions */
	local table_text_`def' = ""
	foreach hr in 20 21 22 23 0 1 2 3 4 {
		local table_text_pt = "`hr'"
		local table_text_se = "`hr'"
		*foreach dt in .13 1 { /* 20%, 60%, and no dropping thresholds */
		foreach dt in .13 { /* 20%, 60%, and no dropping thresholds */
			lp_drinking_unified_prog `agg_type' 1983 1993 `hr' `hr' i.year#i.weekend#i.state `def' `dt' 0 0
			local table_text_pt = "`table_text_pt'" + "," + strofreal(`r(theta)',"%9.2f") + "," + strofreal(`r(lambda)',"%9.2f")
			local table_text_se = "`table_text_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + "),'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
		}
		local table_text_`def' = "`table_text_`def''" + "`table_text_pt'" + char(10)
		local table_text_`def' = "`table_text_`def''" + "`table_text_se'" + char(10)
	}
}

/* then for multiple imputation */
local table_text_mi = ""
foreach hr in 20 21 22 23 0 1 2 3 4 {
	local table_text_pt = "`hr'"
	local table_text_se = "`hr'"
	*foreach dt in .13 1 { /* 20%, 60%, and no dropping thresholds */
	foreach dt in .13 { /* 20%, 60%, and no dropping thresholds */
		mi_lp_drinking_unified_prog `agg_type' 1983 1993 `hr' `hr' i.year#i.weekend#i.state 4 `dt' 0 0
		local table_text_pt = "`table_text_pt'" + "," + strofreal(`r(theta)',"%9.2f") + "," + strofreal(`r(lambda)',"%9.2f")
		local table_text_se = "`table_text_se'" + ",'(" + strofreal(`r(theta_se)',"%9.2f") + "),'(" + strofreal(`r(lambda_se)',"%9.2f") + ")"
	}
	local table_text_mi = "`table_text_mi'" + "`table_text_pt'" + char(10)
	local table_text_mi = "`table_text_mi'" + "`table_text_se'" + char(10)
}

log using figure_2_4_table_text, replace
foreach def in 1 2 3 4 "mi" { /* 4 definitions and multiple imputation */
	disp "****Copy and pasteable (into Google sheets) estimates for Figures 2 and 4, drinking definition `def': "
	disp "`table_text_`def''"
}
log close
*/

